/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.momd;

import com.ibm.hwmca.base.momd.MOMDebugBean;
import com.ibm.hwmca.base.momd.MOMDebugConstants;
import com.ibm.hwmca.base.momd.MOMDebugNodeBranch;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectGroup;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.ClassDescriptors;
import com.ibm.hwmca.fw.util.Localizable;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;

public class MOMDebugTasklet
extends PanelTasklet
implements MOMDebugConstants {
    private ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "MOMDbgTklt");
    private static final String AUIML_PATH = "com/ibm/hwmca/base/momd.res.MOMDebugRes";
    private static final String AUIML_PANELNAME = "MOMDebugPanel";
    private final ClassDescriptors cdDefinitions = ClassDescriptors.getClassDescriptors("MOMDEBUG");
    private TreeMap instances = new TreeMap();
    private static final ArrayList booleanValues = new ArrayList<Object>(Arrays.asList("false", "true"));
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Tower;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$User;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public MOMDebugTasklet() {
        Trace.trace("XMOMD TT", "<> MOMDebugTasklet()");
    }

    public void init(Object initData) {
        Trace.trace("XMOMD TT", "<> init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace("XMOMD TT", "-> service()");
        if (request.isInitialRequest()) {
            Trace.trace("XMOMD TD", "MOMDebugTasklet initial request");
            MOMDebugBean momdBean = new MOMDebugBean();
            response.replace(AUIML_PATH, AUIML_PANELNAME, momdBean);
        } else if (request.isDisposed() || request.isCanceled()) {
            response.terminate();
        } else {
            String requestType = (String)request.getData("Action");
            Trace.trace("XMOMD TF", "MOMDebugTasklet requestType: " + requestType);
            if (requestType.equals("GetKiddies")) {
                Trace.trace("XMOMD TF", "MOMDebugTasklet fetching children");
                String nodeId = (String)request.getData("Node");
                Set nodeValues = null;
                try {
                    nodeValues = nodeId == null ? this.createRootNodes() : this.createChildNodes(nodeId);
                }
                catch (Exception exc) {
                    Trace.trace("XMOMD TF", exc);
                    nodeValues = new HashSet();
                }
                response.update(nodeValues);
                Trace.trace("XMOMD TD", "Returning nodes:");
                Iterator iterator = nodeValues.iterator();
                while (iterator.hasNext()) {
                    Trace.trace("XMOMD TD", iterator.next().toString());
                }
            } else if (requestType.equals("AboutMe")) {
                Trace.trace("XMOMD TF", "MOMDebugTasklet fetching properties");
                String strNode = (String)request.getData("Node");
                HashSet propertyValues = null;
                try {
                    propertyValues = this.getPropertyTable(strNode);
                }
                catch (Exception exc) {
                    Trace.trace("XMOMD TF", exc);
                    propertyValues = new HashSet();
                }
                response.update(propertyValues);
                Trace.trace("XMOMD TD", "Returning properties:");
                Iterator iterator = propertyValues.iterator();
                while (iterator.hasNext()) {
                    Trace.trace("XMOMD TD", iterator.next().toString());
                }
            } else if (requestType.equals("STORENOW")) {
                Trace.trace("XMOMD TD", "MOMDebugTasklet setting properties");
                String nodeId = (String)request.getData("Node");
                if (nodeId != null) {
                    try {
                        Set propertyTable = (Set)request.getData("DATA");
                        Object nodeObject = this.getNode(nodeId);
                        this.setPropertyTable(nodeObject, propertyTable);
                        this.setObjects(nodeObject, nodeId);
                    }
                    catch (Exception exc) {
                        Trace.trace("XMOMD TF", exc);
                    }
                }
                response.noAction();
            } else {
                response.noAction();
            }
        }
        Trace.trace("XMOMD TT", "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace("XMOMD TF", throwable);
    }

    private Set createRootNodes() {
        Trace.trace("XMOMD TT", "-> createRootNodes()");
        TreeSet<MOMDebugNodeBranch.NodeValue> result = new TreeSet<MOMDebugNodeBranch.NodeValue>();
        if (this.instances.isEmpty()) {
            String name;
            Trace.trace("XMOMD TF", "Building root instances");
            ArrayList<HwmcaObject> tasks = new ArrayList<HwmcaObject>();
            ArrayList<HwmcaObject> towers = new ArrayList<HwmcaObject>();
            ArrayList<HwmcaObject> users = new ArrayList<HwmcaObject>();
            Set inventory = this.mom.getInventory(new ClassId((class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaObject = MOMDebugTasklet.class$("com.ibm.hwmca.fw.managed.HwmcaObject")) : class$com$ibm$hwmca$fw$managed$HwmcaObject).getName()));
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                String displayName;
                String name2;
                HwmcaObject hwmcaObject = (HwmcaObject)iterator.next();
                if (hwmcaObject instanceof ManagedObjectGroup) {
                    if (!((ManagedObjectGroup)hwmcaObject).isRoot()) continue;
                    Trace.trace("XMOMD TT", " added ManagedObjectGroup " + hwmcaObject);
                    name2 = hwmcaObject.getObjectId().toString();
                    this.instances.put(name2, hwmcaObject);
                    displayName = hwmcaObject.getUIInfo().getName();
                    result.add(new MOMDebugNodeBranch.NodeValue(name2, (Comparable)((Object)displayName)));
                    continue;
                }
                if (hwmcaObject instanceof Task) {
                    tasks.add(hwmcaObject);
                    continue;
                }
                if (hwmcaObject instanceof Tower) {
                    towers.add(hwmcaObject);
                    continue;
                }
                if (hwmcaObject instanceof User) {
                    users.add(hwmcaObject);
                    continue;
                }
                if (!(hwmcaObject instanceof HMC)) continue;
                Trace.trace("XMOMD TT", " added HMC");
                name2 = hwmcaObject.getObjectId().toString();
                this.instances.put(name2, hwmcaObject);
                displayName = hwmcaObject.getUIInfo().getName();
                result.add(new MOMDebugNodeBranch.NodeValue(name2, (Comparable)((Object)displayName)));
            }
            if (!tasks.isEmpty()) {
                Trace.trace("XMOMD TT", " added Tasks");
                name = (class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = MOMDebugTasklet.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task).getName();
                this.instances.put(name, tasks);
                result.add(new MOMDebugNodeBranch.NodeValue(name, (Comparable)((Object)"Tasks")));
            }
            if (!towers.isEmpty()) {
                Trace.trace("XMOMD TT", " added Towers");
                name = (class$com$ibm$hwmca$fw$managed$Tower == null ? (class$com$ibm$hwmca$fw$managed$Tower = MOMDebugTasklet.class$("com.ibm.hwmca.fw.managed.Tower")) : class$com$ibm$hwmca$fw$managed$Tower).getName();
                this.instances.put(name, towers);
                result.add(new MOMDebugNodeBranch.NodeValue(name, (Comparable)((Object)"Towers")));
            }
            if (!users.isEmpty()) {
                Trace.trace("XMOMD TT", " added Users");
                name = (class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = MOMDebugTasklet.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User).getName();
                this.instances.put(name, users);
                result.add(new MOMDebugNodeBranch.NodeValue(name, (Comparable)((Object)"Users")));
            }
        }
        Trace.trace("XMOMD TT", "<- createRootNodes()");
        return result;
    }

    private Set createChildNodes(String nodeId) {
        Trace.trace("XMOMD TT", "-> createChildNodes(nodeId=" + nodeId + ")");
        TreeSet<MOMDebugNodeBranch.NodeValue> result = new TreeSet<MOMDebugNodeBranch.NodeValue>();
        Object[] nodeObject = this.getNode(nodeId);
        if (nodeObject instanceof Object[] || nodeObject instanceof Collection || nodeObject instanceof Map) {
            if (nodeObject instanceof Map) {
                nodeObject = ((Map)nodeObject).values();
            }
            if (nodeObject instanceof Collection) {
                nodeObject = nodeObject.toArray();
            }
            int ix = 0;
            while (ix < nodeObject.length) {
                Object childValue = nodeObject[ix];
                Trace.trace("XMOMD TF", "Processing child[" + ix + "]=" + childValue);
                String childNodeId = nodeId + '|' + ix;
                if (childValue instanceof ObjectId) {
                    childValue = this.mom.get((ObjectId)childValue);
                }
                if (childValue != null && this.isNode(childValue.getClass().getName())) {
                    UIInfo uiInfo;
                    String displayName = childValue.toString();
                    if (childValue instanceof HwmcaObject && (uiInfo = ((HwmcaObject)childValue).getUIInfo()) != null) {
                        displayName = uiInfo.getName();
                    }
                    Trace.trace("XMOMD TD", "Adding node: " + childNodeId);
                    result.add(new MOMDebugNodeBranch.NodeValue(childNodeId, (Comparable)((Object)displayName)));
                }
                ++ix;
            }
        } else {
            CIMClass cimClass = this.cdDefinitions.findClass(nodeObject.getClass().getName());
            if (cimClass == null) {
                throw new IllegalArgumentException("Descriptor not found for class " + nodeObject.getClass().getName());
            }
            List properties = this.getAllProperties(cimClass);
            Trace.trace("XMOMD TF", "Have " + properties.size() + " properties to go through.");
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                CIMProperty cimProperty = (CIMProperty)iterator.next();
                if (!this.isNode(cimProperty)) continue;
                String childNodeId = nodeId + '|' + cimProperty.getName();
                String displayName = cimProperty.getName();
                CIMQualifier cimQualifier = cimProperty.getQualifier("DISPLAYNAME");
                if (cimQualifier != null) {
                    CIMValue cimValue = cimQualifier.getValue();
                    displayName = cimValue.toString();
                    Trace.trace("XMOMD TF", "Overriding displayname: " + displayName);
                }
                Trace.trace("XMOMD TD", "Adding node: " + childNodeId);
                result.add(new MOMDebugNodeBranch.NodeValue(childNodeId, (Comparable)((Object)displayName)));
            }
        }
        Trace.trace("XMOMD TT", "<- createChildNodes()");
        return result;
    }

    private boolean isNode(CIMProperty cimProperty) {
        Trace.trace("XMOMD TD", "> isNode(cimProperty=" + (cimProperty == null ? "null" : cimProperty.getName()) + ")");
        boolean result = false;
        if (cimProperty.isReference()) {
            result = this.isNode(cimProperty.getType().getRefClassName());
        }
        Trace.trace("XMOMD TD", "< isNode(returns " + result + ")");
        return result;
    }

    private boolean isNode(String className) {
        Trace.trace("XMOMD TD", "> isNode(className=" + className + ")");
        boolean result = false;
        CIMClass refClass = this.cdDefinitions.findClass(className);
        if (refClass != null) {
            if (refClass.getAllProperties().size() > 0) {
                result = true;
            } else {
                String superClass = refClass.getSuperClass();
                if (superClass != null) {
                    result = this.isNode(superClass);
                }
            }
        } else {
            try {
                Class<?> javaClass = Class.forName(className);
                if (javaClass.isArray() || (class$java$util$Collection == null ? (class$java$util$Collection = MOMDebugTasklet.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(javaClass) || (class$java$util$Map == null ? (class$java$util$Map = MOMDebugTasklet.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(javaClass)) {
                    result = true;
                }
            }
            catch (Exception exc) {
                Trace.trace("XMOMD TF", exc);
            }
        }
        Trace.trace("XMOMD TD", "< isNode(returns " + result + ")");
        return result;
    }

    private List getAllProperties(CIMClass cimClass) {
        ArrayList<CIMProperty> result = new ArrayList<CIMProperty>();
        if (cimClass != null) {
            Trace.trace("XMOMD TT", "-> getAllProperties(cimClass=" + cimClass.getName() + ")");
            Vector properties = cimClass.getAllProperties();
            result.addAll(properties);
            String superClassName = cimClass.getSuperClass();
            if (superClassName != null && !superClassName.equals("")) {
                CIMClass superclass = this.cdDefinitions.findClass(superClassName);
                List newProperties = this.getAllProperties(superclass);
                Iterator iterator1 = newProperties.iterator();
                while (iterator1.hasNext()) {
                    CIMProperty property1 = (CIMProperty)iterator1.next();
                    String propertyName1 = property1.getName();
                    boolean found = false;
                    Iterator iterator2 = result.iterator();
                    while (iterator2.hasNext()) {
                        String propertyName2 = ((CIMProperty)iterator2.next()).getName();
                        if (!propertyName1.equalsIgnoreCase(propertyName2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    result.add(property1);
                }
            }
            Trace.trace("XMOMD TT", "<- getAllProperties(returns " + result.size() + " properties");
        }
        return result;
    }

    private Object getNode(String nodeId) {
        return this.getNode(null, nodeId);
    }

    private Object getNode(Object nodeObject, String nodeId) {
        Trace.trace("XMOMD TT", "-> getNode(nodeObject=" + nodeObject + ",nodeId=" + nodeId + ")");
        Object result = null;
        String propertyName = null;
        int index = nodeId.lastIndexOf(124);
        if (index > 0) {
            propertyName = nodeId.substring(index + 1);
            nodeObject = this.getNode(nodeObject, nodeId.substring(0, index));
        }
        if (propertyName == null) {
            result = this.instances.get(nodeId);
        } else if (nodeObject instanceof Object[] || nodeObject instanceof Collection || nodeObject instanceof Map) {
            try {
                index = Integer.decode(propertyName);
                if (nodeObject instanceof Object[]) {
                    result = ((Object[])nodeObject)[index];
                } else {
                    if (nodeObject instanceof Map) {
                        result = ((Map)nodeObject).values();
                    }
                    Iterator iterator = ((Collection)nodeObject).iterator();
                    int i = 0;
                    while (i <= index && iterator.hasNext()) {
                        result = iterator.next();
                        ++i;
                    }
                }
                if (result != null && result instanceof ObjectId) {
                    result = this.mom.get((ObjectId)result);
                }
            }
            catch (Exception exc) {
                Trace.trace("XMOMD TF", exc);
            }
        } else {
            CIMClass cimClass = this.cdDefinitions.findClass(nodeObject.getClass().getName());
            if (cimClass == null) {
                throw new IllegalArgumentException("Descriptor was not found for class " + nodeObject.getClass().getName());
            }
            CIMProperty cimProperty = this.cdDefinitions.findProperty(cimClass, propertyName);
            if (cimProperty == null) {
                throw new IllegalArgumentException("Could not find property " + propertyName + " in class " + nodeObject.getClass().getName());
            }
            CIMMethod cimMethod = this.cdDefinitions.findGetMethod(cimProperty);
            if (cimProperty == null) {
                throw new IllegalArgumentException("Could not find get method for property " + propertyName + " in class " + nodeObject.getClass().getName());
            }
            try {
                result = this.cdDefinitions.invokeMethod(cimMethod, nodeObject, new Object[0]);
            }
            catch (Throwable thrown) {
                Trace.trace("XMOMD TF", thrown);
            }
        }
        Trace.trace("XMOMD TT", "<- getNode(return " + result + ")");
        return result;
    }

    private Set getPropertyTable(String nodeId) {
        Trace.trace("XMOMD TF", "-> getPropertyTable(nodeId=" + nodeId + ")");
        Object[] nodeObject = this.getNode(nodeId);
        TreeSet<MOMDebugNodeBranch.PropertyValue> result = new TreeSet<MOMDebugNodeBranch.PropertyValue>();
        if (nodeObject instanceof Object[] || nodeObject instanceof Collection || nodeObject instanceof Map) {
            Trace.trace("XMOMD TF", "Am getting value for type: " + nodeObject.getClass().getName());
            if (nodeObject != null && nodeObject instanceof Map) {
                nodeObject = ((Map)nodeObject).values();
            }
            if (nodeObject != null && nodeObject instanceof Collection) {
                nodeObject = nodeObject.toArray();
            }
            if (nodeObject != null) {
                int ix = 0;
                while (ix < nodeObject.length) {
                    Integer index = new Integer(ix);
                    String childNodeId = nodeId + '|' + index;
                    Object value = nodeObject[ix];
                    if (!this.isNode(value.getClass().getName())) {
                        String strValue = "<null>";
                        strValue = value instanceof Localizable ? ((Localizable)value).toUnlocalizedString() : value.toString();
                        result.add(new MOMDebugNodeBranch.PropertyValue(childNodeId, index, strValue));
                    }
                    ++ix;
                }
            }
        } else {
            CIMClass cimClass = this.cdDefinitions.findClass(nodeObject.getClass().getName());
            if (cimClass == null) {
                throw new IllegalArgumentException("Descriptor not found for class " + nodeObject.getClass().getName());
            }
            List properties = this.getAllProperties(cimClass);
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                CIMProperty cimProperty = (CIMProperty)iterator.next();
                if (this.isNode(cimProperty)) continue;
                String childNodeId = nodeId + '|' + cimProperty.getName();
                String displayName = cimProperty.getName();
                CIMQualifier cimQualifier = cimProperty.getQualifier("DISPLAYNAME");
                if (cimQualifier != null) {
                    CIMValue cimValue = cimQualifier.getValue();
                    displayName = cimValue.toString();
                }
                String value = null;
                try {
                    value = this.cdDefinitions.getPropertyValue(cimProperty, nodeObject);
                }
                catch (Throwable e) {
                    Trace.trace("XMOMD TF", "Cannot get value for property " + (cimProperty == null ? "null" : cimProperty.getName()));
                    Trace.trace("XMOMD TF", e);
                    value = "<Error retrieving property value>";
                }
                if (value == null) {
                    value = "<null>";
                }
                result.add(new MOMDebugNodeBranch.PropertyValue(childNodeId, (Comparable)((Object)displayName), value));
            }
        }
        Trace.trace("XMOMD TF", "<- getPropertyTable()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyTable(Object nodeObject, Set properties) {
        if (nodeObject != null && properties != null) {
            Trace.trace("XMOMD TT", "-> setPropertyTable(" + nodeObject.getClass().getName() + ", " + properties.size() + " properties)");
            CIMClass cimClass = this.cdDefinitions.findClass(nodeObject.getClass().getName());
            if (cimClass == null) {
                throw new IllegalArgumentException("Descriptor not found for class " + nodeObject.getClass().getName());
            }
            if (nodeObject instanceof HwmcaObject) {
                Object object = ((HwmcaObject)nodeObject).setAutoPersist(false);
                synchronized (object) {
                    this.setProperties(nodeObject, cimClass, properties);
                    try {
                        ((HwmcaObject)nodeObject).persist();
                    }
                    catch (Exception e) {
                        Trace.trace("XMOMD TF", e);
                    }
                }
            }
            this.setProperties(nodeObject, cimClass, properties);
            Trace.trace("XMOMD TT", "<- setPropertyTable()");
        }
    }

    private void setProperties(Object nodeObject, CIMClass cimClass, Set properties) {
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            try {
                MOMDebugNodeBranch.PropertyValue propertyValue = (MOMDebugNodeBranch.PropertyValue)iterator.next();
                CIMProperty cimProperty = this.cdDefinitions.findProperty(cimClass, propertyValue.getName());
                this.cdDefinitions.setPropertyValue(cimProperty, nodeObject, propertyValue.getValue());
            }
            catch (Throwable e) {
                Trace.trace("XMOMD TF", e);
            }
        }
    }

    private void setObjects(Object nodeObject, String nodeId) {
        Trace.trace("XMOMD TT", "-> setObjects(nodeObject=" + nodeObject.getClass().getName() + ",nodeId=" + nodeId + ")");
        int index = nodeId.lastIndexOf(124);
        if (index > 0) {
            String propertyName = nodeId.substring(index + 1);
            Object parent = this.getNode(nodeId = nodeId.substring(0, index));
            CIMClass cimClass = this.cdDefinitions.findClass(parent.getClass().getName());
            if (cimClass != null) {
                CIMProperty cimProperty = this.cdDefinitions.findProperty(cimClass, propertyName);
                if (cimProperty == null) {
                    throw new IllegalArgumentException("Property " + propertyName + " not found for class " + parent.getClass().getName());
                }
                CIMMethod cimMethod = this.cdDefinitions.findSetMethod(cimProperty);
                if (cimMethod == null) {
                    throw new IllegalArgumentException("Set method for property " + propertyName + " not found for class " + parent.getClass().getName());
                }
                try {
                    this.cdDefinitions.invokeMethod(cimMethod, parent, new Object[]{nodeObject});
                    if (!(parent instanceof HwmcaObject)) {
                        this.setObjects(parent, nodeId);
                    }
                }
                catch (Throwable e) {
                    Trace.trace("XMOMD TF", e);
                }
            }
        }
        Trace.trace("XMOMD TT", "<- setObjects()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

